//Image auto slideshow
// create variable to index the slides - to track the slides
var slideIndex = 0;
// call a function that does something with the slides
showSlides();

function showSlides() {
  // a variable to be used in the for loop - i for "index"
  var i;
  // target the slides in the DOM as slides
  var slides = document.getElementsByClassName("mySlides");
  // loop through the slides showing them one at a time (display)
  for (i = 0; i < slides.length; i++) {
    slides[i].style.display = "none"; //none hides the slides
  }
  // increment the slides from 0 to the total number of slides (for loop)
  slideIndex++;
  // loop back to the beginning
  if (slideIndex > slides.length) {
    slideIndex = 1;
  }
  slides[slideIndex - 1].style.display = "block"; //show the slide
  setTimeout(showSlides, 2000); // Change image every 2 seconds
}

//Make the DIV element draggagle, vanilla js:
//https://www.w3schools.com/howto/howto_js_draggable.asp
dragElement(document.getElementById("mydiv"));

function dragElement(elmnt) {
  var pos1 = 0,
    pos2 = 0,
    pos3 = 0,
    pos4 = 0;
  if (document.getElementById(elmnt.id + "header")) {
    /* if present, the header is where you move the DIV from:*/
    document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
  } else {
    /* otherwise, move the DIV from anywhere inside the DIV:*/
    elmnt.onmousedown = dragMouseDown;
  }

  function dragMouseDown(e) {
    e = e || window.event;
    e.preventDefault();
    // get the mouse cursor position at startup:
    pos3 = e.clientX;
    pos4 = e.clientY;
    document.onmouseup = closeDragElement;
    // call a function whenever the cursor moves:
    document.onmousemove = elementDrag;
  }

  function elementDrag(e) {
    e = e || window.event;
    e.preventDefault();
    // calculate the new cursor position:
    pos1 = pos3 - e.clientX;
    pos2 = pos4 - e.clientY;
    pos3 = e.clientX;
    pos4 = e.clientY;
    // set the element's new position:
    elmnt.style.top = elmnt.offsetTop - pos2 + "px";
    elmnt.style.left = elmnt.offsetLeft - pos1 + "px";
  }

  function closeDragElement() {
    /* stop moving when mouse button is released:*/
    document.onmouseup = null;
    document.onmousemove = null;
  }
}

// YouTube API
// https://developers.google.com/youtube/iframe_api_reference
// Load the IFrame Player API code asynchronously.
var tag = document.createElement("script");
tag.src = "https://www.youtube.com/player_api";
var firstScriptTag = document.getElementsByTagName("script")[0];
firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

// Replace the 'ytplayer' element with an <iframe> and
// YouTube player after the API code downloads.
var player;
function onYouTubePlayerAPIReady() {
  player = new YT.Player("ytplayer", {
    // ytplayer does not allow fullscreen video, however you can use CSS to change that
    //height: '480',
    width: "600",
    videoId: "2PmNMN-LBUo",
    playerVars: {
      //Player Parameters
      // https://developers.google.com/youtube/player_parameters?playerVersion=HTML5
      autoplay: 1,
      controls: 0, // 2 - faster performance, does not allow Flash player to initialize, 0 hides, 1 shows
      autohide: 1, //hides player bar
      modestbranding: 1,
      rel: 0, // turns off grid of related videos at end of playback
    },
  });
}
