//This sprite animation code is from:
// https://medium.com/dailyjs/how-to-build-a-simple-sprite-animation-in-javascript-b764644244aa
//Uses ES 6: https://www.freecodecamp.org/news/write-less-do-more-with-javascript-es6-5fd4a8e50ee2/
/*
ECMAScript (or ES) is a scripting-language specification standardized by Ecma International in ECMA-262 and ISO/IEC 16262. It was created to standardize JavaScript to help foster multiple independent implementations
*/

var go; //Use this variable to clear the setInterval()

function stopAnimate() {
  clearInterval(go);
} //end of stopAnimate()


function animateScript() {
  //image (sprite) size is 2100x301 pixels
  var position = 300; //start position for the image slicer
  const interval = 100; //100 ms of interval for the setInterval()
  const diff = 300; //diff as a variable for position offset

  go = setInterval(() => {

    document.getElementById("run").style.backgroundPosition =
      `-${position}px 0px`;
    //Use the ES6 template literal to insert the variable "position"
    /*Template literals are enclosed by the backtick (` `)  (grave accent) character instead of double or single quotes.
    Template literals can contain placeholders. These are indicated by the dollar sign and curly braces (${expression}). The expressions in the placeholders and the text between the backticks (` `) get passed to a function.*/

    if (position < 2100) {
      position = position + diff;
    }
    //Increment the position by 300 each time
    else {
      position = 300;
    }
    //Reset the position to 300px, once position exceeds 2100px

  }, interval); //end of setInterval
} //end of animateScript()
